﻿using System;
using System.Collections.Generic;

namespace PpmsDataService.ModelsEnumTypes
{

    public enum Network
    {
        AnyNetwork = 0,
        CcnRegion1 = 1,
        CcnRegion2 = 2,
        CcnRegion3 = 3,
        CcnRegion4 = 4,
        DepartmentOfDefense = 5,
        IndianHealthService = 6,
        OtherLocalContract = 7,
        ProviderAgreement = 8,
        TraditionalCommunityCare = 9,
        TriWest = 10,
        VaNetwork = 11,
        VaProvider = 12,
        VeteranCareAgreement = 13        
    }

    public struct NetworkId
    {
        public NetworkId(Guid guid, int number, string name) : this()
        {
            Id = guid;
            Number = number;
            NetworkName = name;
        }

        public Guid Id { get; }
        public int Number { get; }
        public string NetworkName { get; }
    }

    public class NetworkIds
    {
        private static List<NetworkId> _networks;
        static NetworkIds()
        {
            _networks = new List<NetworkId>();
            _networks.Add(new NetworkId(new Guid(), 0, "AnyNetwork"));
            _networks.Add(new NetworkId(new Guid("6B0D0B06-8B99-E811-811B-1458D04E0CA0"), 1, "IndividualAuthorization"));
            _networks.Add(new NetworkId(new Guid("4BF4C2C3-F490-E811-811A-1458D0509D88"), 2, "OtherLocalContract"));
            _networks.Add(new NetworkId(new Guid("2AB01B0B-864C-E711-810B-1458D04D2538"), 3, "ProviderAgreement"));
            _networks.Add(new NetworkId(new Guid("FE3A1C16-F590-E811-811A-1458D0509D88"), 4, "CcnRegion4"));
            _networks.Add(new NetworkId(new Guid("46C5DA4E-F590-E811-811A-1458D0509D88"), 5, "DepartmentOfDefense"));
            _networks.Add(new NetworkId(new Guid("1F09A140-F590-E811-811A-1458D0509D88"), 6, "IndianHealthService"));
            _networks.Add(new NetworkId(new Guid("4BF4C2C3-F490-E811-811A-1458D0509D88"), 7, "OtherLocalContract"));
            _networks.Add(new NetworkId(new Guid("2AB01B0B-864C-E711-810B-1458D04D2538"), 8, "ProviderAgreement"));
            _networks.Add(new NetworkId(new Guid("D300A978-F490-E811-811A-1458D0509D88"), 9, "TraditionalCommunityCare"));
            _networks.Add(new NetworkId(new Guid("9A23DDBF-F6BB-E611-8100-1458D04E8FF8"), 10, "TriWest"));
            _networks.Add(new NetworkId(new Guid("AF34785D-9FF4-E711-8123-1458D04EF938"), 11, "VaNetwork"));
            _networks.Add(new NetworkId(new Guid("D39B7939-F490-E811-811A-1458D0509D88"), 12, "VaProvider"));
            _networks.Add(new NetworkId(new Guid("BAC98E9D-F490-E811-811A-1458D0509D88"), 13, "VeteranCareAgreement"));
        }

        public static NetworkId GetNetwork(Guid uuid)
        {
            return _networks.Find(n => n.Id == uuid);
        }

        public static NetworkId GetNetwork(int number)
        {
            return _networks.Find(n => n.Number == number);
        }

        public static NetworkId GetNetwork(string name)
        {
            return _networks.Find(n => n.NetworkName == name);
        }
    }
}